/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.utils.universe.ConfigScreen;
import com.sun.j3d.utils.universe.ConfigView;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewerAvatar;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class Viewer {
    private static final boolean debug = false;
    private static PhysicalBody physicalBody = null;
    private static PhysicalEnvironment physicalEnvironment = null;
    private View view;
    private ViewerAvatar avatar;
    private Canvas3D[] canvases;
    private JFrame[] j3dJFrames;
    private JPanel[] j3dJPanels;
    private Window[] j3dWindows;
    private ViewingPlatform viewingPlatform;
    static HashMap viewerMap = new HashMap(5);
    private float dvrFactor;
    private boolean doDvr;
    private boolean doDvrResizeCompensation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Viewer getViewer(View view) {
        Viewer viewer = null;
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewer = (Viewer)viewerMap.get(view);
        }
        return viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Viewer removeViewerMapEntry(View view) {
        Viewer viewer = null;
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewer = (Viewer)viewerMap.remove(view);
        }
        return viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearViewerMap() {
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewerMap.clear();
        }
    }

    public boolean isDvrEnabled() {
        return this.doDvr;
    }

    public void setDvrEnable(boolean bl) {
        this.doDvr = bl;
        this.view.repaint();
    }

    public float getDvrFactor() {
        return this.dvrFactor;
    }

    public void setDvrFactor(float f2) {
        this.dvrFactor = f2;
        this.view.repaint();
    }

    public void setDvrResizeCompensationEnable(boolean bl) {
        this.doDvrResizeCompensation = bl;
        this.view.repaint();
    }

    public boolean getDvrResizeCompensationEnable() {
        return this.doDvrResizeCompensation;
    }

    public Viewer() {
        this(null, null, null, true);
    }

    public Viewer(Canvas3D canvas3D) {
        Canvas3D[] canvas3DArray;
        if (canvas3D == null) {
            canvas3DArray = null;
        } else {
            Canvas3D[] canvas3DArray2 = new Canvas3D[1];
            canvas3DArray = canvas3DArray2;
            canvas3DArray2[0] = canvas3D;
        }
        this(canvas3DArray, null, null, true);
    }

    public Viewer(Canvas3D[] canvas3DArray) {
        this(canvas3DArray, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Viewer(Canvas3D[] canvas3DArray, PhysicalBody physicalBody, PhysicalEnvironment physicalEnvironment, boolean bl) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.dvrFactor = 1.0f;
        this.doDvr = false;
        this.doDvrResizeCompensation = true;
        Viewer.physicalBody = physicalBody == null ? new PhysicalBody() : physicalBody;
        Viewer.physicalEnvironment = physicalEnvironment == null ? new PhysicalEnvironment() : physicalEnvironment;
        if (canvas3DArray == null) {
            GraphicsConfiguration graphicsConfiguration = ConfiguredUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D(graphicsConfiguration);
            try {
                this.canvases[0].setFocusable(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            this.createFramesAndPanels(bl);
        } else {
            this.canvases = new Canvas3D[canvas3DArray.length];
            for (int i2 = 0; i2 < canvas3DArray.length; ++i2) {
                this.canvases[i2] = canvas3DArray[i2];
                try {
                    this.canvases[i2].setFocusable(true);
                    continue;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        this.view = new View();
        this.view.setUserHeadToVworldEnable(true);
        HashMap hashMap = viewerMap;
        synchronized (hashMap) {
            viewerMap.put(this.view, this);
        }
        for (int i3 = 0; i3 < this.canvases.length; ++i3) {
            this.view.addCanvas3D(this.canvases[i3]);
        }
        this.view.setPhysicalBody(Viewer.physicalBody);
        this.view.setPhysicalEnvironment(Viewer.physicalEnvironment);
    }

    public Viewer(URL uRL) {
        this(null, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Viewer(Canvas3D canvas3D, URL uRL) {
        Object object;
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.dvrFactor = 1.0f;
        this.doDvr = false;
        this.doDvrResizeCompensation = true;
        if (physicalBody == null) {
            physicalBody = new PhysicalBody();
        }
        if (physicalEnvironment == null) {
            physicalEnvironment = new PhysicalEnvironment();
        }
        if (canvas3D == null) {
            object = SimpleUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D((GraphicsConfiguration)object);
            this.createFramesAndPanels(true);
        } else {
            this.canvases = new Canvas3D[1];
            this.canvases[0] = canvas3D;
        }
        try {
            this.canvases[0].setFocusable(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.view = new View();
        this.view.setUserHeadToVworldEnable(true);
        object = viewerMap;
        synchronized (object) {
            viewerMap.put(this.view, this);
        }
        this.view.addCanvas3D(this.canvases[0]);
        this.view.setPhysicalBody(physicalBody);
        this.view.setPhysicalEnvironment(physicalEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Viewer(ConfigScreen[] configScreenArray, ConfigView configView, boolean bl) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.dvrFactor = 1.0f;
        this.doDvr = false;
        this.doDvrResizeCompensation = true;
        this.view = configView.j3dView;
        GraphicsDevice[] graphicsDeviceArray = viewerMap;
        synchronized (viewerMap) {
            viewerMap.put(this.view, this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            physicalBody = configView.physicalBody;
            physicalEnvironment = configView.physicalEnvironment;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            if (graphicsDeviceArray == null) {
                throw new RuntimeException("No screen devices available in local environment");
            }
            this.canvases = new Canvas3D[configScreenArray.length];
            this.j3dJFrames = new JFrame[configScreenArray.length];
            this.j3dJPanels = new JPanel[configScreenArray.length];
            this.j3dWindows = new Window[configScreenArray.length];
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            if (configView.stereoEnable) {
                graphicsConfigTemplate3D.setStereo(2);
            }
            if (configView.antialiasingEnable) {
                graphicsConfigTemplate3D.setSceneAntialiasing(2);
            }
            for (int i2 = 0; i2 < configScreenArray.length; ++i2) {
                Container container;
                if (configScreenArray[i2].frameBufferNumber >= graphicsDeviceArray.length) {
                    ConfigScreen cfr_ignored_0 = configScreenArray[i2];
                    throw new ArrayIndexOutOfBoundsException(ConfigScreen.errorMessage(configScreenArray[i2].creatingCommand, "Screen " + configScreenArray[i2].frameBufferNumber + " is invalid; " + (graphicsDeviceArray.length - 1) + " is the maximum local index."));
                }
                GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[configScreenArray[i2].frameBufferNumber].getBestConfiguration(graphicsConfigTemplate3D);
                if (graphicsConfiguration == null) {
                    throw new RuntimeException("No GraphicsConfiguration on screen " + configScreenArray[i2].frameBufferNumber + " conforms to template");
                }
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfiguration.getDevice().getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration2.getBounds();
                configScreenArray[i2].j3dJFrame = this.j3dJFrames[i2] = new JFrame(configScreenArray[i2].instanceName, graphicsConfiguration2);
                if (configScreenArray[i2].noBorderFullScreen) {
                    try {
                        this.j3dJFrames[i2].setUndecorated(true);
                        configScreenArray[i2].j3dWindow = this.j3dWindows[i2] = this.j3dJFrames[i2];
                        container = this.j3dJFrames[i2].getContentPane();
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        JWindow jWindow = new JWindow(this.j3dJFrames[i2], graphicsConfiguration);
                        configScreenArray[i2].j3dWindow = this.j3dWindows[i2] = jWindow;
                        container = jWindow.getContentPane();
                    }
                    container.setLayout(new BorderLayout());
                    this.j3dWindows[i2].setSize(rectangle.width, rectangle.height);
                    this.j3dWindows[i2].setLocation(rectangle.x, rectangle.y);
                } else {
                    configScreenArray[i2].j3dWindow = this.j3dWindows[i2] = this.j3dJFrames[i2];
                    container = this.j3dJFrames[i2].getContentPane();
                    container.setLayout(new BorderLayout());
                    if (configScreenArray[i2].fullScreen) {
                        this.j3dWindows[i2].setSize(rectangle.width, rectangle.height);
                        this.j3dWindows[i2].setLocation(rectangle.x, rectangle.y);
                    } else {
                        this.j3dWindows[i2].setSize(configScreenArray[i2].windowWidthInPixels, configScreenArray[i2].windowHeightInPixels);
                        this.j3dWindows[i2].setLocation(rectangle.x + configScreenArray[i2].windowX, rectangle.y + configScreenArray[i2].windowY);
                    }
                }
                configScreenArray[i2].j3dCanvas = this.canvases[i2] = new Canvas3D(graphicsConfiguration);
                this.canvases[i2].setStereoEnable(configView.stereoEnable);
                this.canvases[i2].setMonoscopicViewPolicy(configScreenArray[i2].monoscopicViewPolicy);
                Screen3D screen3D = this.canvases[i2].getScreen3D();
                if (configScreenArray[i2].physicalScreenWidth != 0.0) {
                    screen3D.setPhysicalScreenWidth(configScreenArray[i2].physicalScreenWidth);
                }
                if (configScreenArray[i2].physicalScreenHeight != 0.0) {
                    screen3D.setPhysicalScreenHeight(configScreenArray[i2].physicalScreenHeight);
                }
                if (configScreenArray[i2].trackerBaseToImagePlate != null) {
                    screen3D.setTrackerBaseToImagePlate(new Transform3D(configScreenArray[i2].trackerBaseToImagePlate));
                }
                if (configScreenArray[i2].headTrackerToLeftImagePlate != null) {
                    screen3D.setHeadTrackerToLeftImagePlate(new Transform3D(configScreenArray[i2].headTrackerToLeftImagePlate));
                }
                if (configScreenArray[i2].headTrackerToRightImagePlate != null) {
                    screen3D.setHeadTrackerToRightImagePlate(new Transform3D(configScreenArray[i2].headTrackerToRightImagePlate));
                }
                configScreenArray[i2].j3dJPanel = this.j3dJPanels[i2] = new JPanel();
                this.j3dJPanels[i2].setLayout(new BorderLayout());
                this.j3dJPanels[i2].add("Center", this.canvases[i2]);
                container.add("Center", this.j3dJPanels[i2]);
                this.view.addCanvas3D(this.canvases[i2]);
                this.addWindowCloseListener(this.j3dWindows[i2]);
                try {
                    this.canvases[i2].setFocusable(true);
                    continue;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            if (bl) {
                this.setVisible(true);
            }
            return;
        }
    }

    private void createFramesAndPanels(boolean bl) {
        this.j3dJFrames = new JFrame[this.canvases.length];
        this.j3dJPanels = new JPanel[this.canvases.length];
        this.j3dWindows = new Window[this.canvases.length];
        for (int i2 = 0; i2 < this.canvases.length; ++i2) {
            this.j3dJFrames[i2] = new JFrame();
            this.j3dWindows[i2] = this.j3dJFrames[i2];
            this.j3dJFrames[i2].getContentPane().setLayout(new BorderLayout());
            this.j3dJFrames[i2].setSize(256, 256);
            this.j3dJPanels[i2] = new JPanel();
            this.j3dJPanels[i2].setLayout(new BorderLayout());
            this.j3dJPanels[i2].add("Center", this.canvases[i2]);
            this.j3dJFrames[i2].getContentPane().add("Center", this.j3dJPanels[i2]);
            if (bl) {
                this.j3dJFrames[i2].setVisible(true);
            }
            this.addWindowCloseListener(this.j3dJFrames[i2]);
        }
    }

    public void setVisible(boolean bl) {
        for (int i2 = 0; i2 < this.j3dWindows.length; ++i2) {
            this.j3dWindows[i2].setVisible(bl);
        }
    }

    public View getView() {
        return this.view;
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        if (this.viewingPlatform != null) {
            this.viewingPlatform.removeViewer(this);
        }
        this.viewingPlatform = viewingPlatform;
        if (viewingPlatform != null) {
            this.view.attachViewPlatform(viewingPlatform.getViewPlatform());
            viewingPlatform.addViewer(this);
            if (this.avatar != null) {
                this.viewingPlatform.setAvatar(this, this.avatar);
            }
        } else {
            this.view.attachViewPlatform(null);
        }
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewingPlatform;
    }

    public void setAvatar(ViewerAvatar viewerAvatar) {
        if (this.avatar == viewerAvatar) {
            return;
        }
        this.avatar = viewerAvatar;
        if (this.viewingPlatform != null) {
            this.viewingPlatform.setAvatar(this, this.avatar);
        }
    }

    public ViewerAvatar getAvatar() {
        return this.avatar;
    }

    public PhysicalBody getPhysicalBody() {
        return physicalBody;
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return physicalEnvironment;
    }

    public Canvas3D getCanvas3D() {
        return this.canvases[0];
    }

    public Canvas3D getCanvas3D(int n2) {
        if (n2 > this.canvases.length) {
            return null;
        }
        return this.canvases[n2];
    }

    public Canvas3D[] getCanvas3Ds() {
        Canvas3D[] canvas3DArray = new Canvas3D[this.canvases.length];
        for (int i2 = 0; i2 < this.canvases.length; ++i2) {
            canvas3DArray[i2] = this.canvases[i2];
        }
        return canvas3DArray;
    }

    public Canvas3D getCanvases() {
        return this.getCanvas3D();
    }

    public Frame getFrame() {
        throw new UnsupportedOperationException("AWT Frame components are not created by the Viewer class");
    }

    public JFrame getJFrame(int n2) {
        if (this.j3dJFrames == null || n2 > this.j3dJFrames.length) {
            return null;
        }
        return this.j3dJFrames[n2];
    }

    public JFrame[] getJFrames() {
        if (this.j3dJFrames == null) {
            return null;
        }
        JFrame[] jFrameArray = new JFrame[this.j3dJFrames.length];
        for (int i2 = 0; i2 < this.j3dJFrames.length; ++i2) {
            jFrameArray[i2] = this.j3dJFrames[i2];
        }
        return jFrameArray;
    }

    public Panel getPanel() {
        throw new UnsupportedOperationException("AWT Panel components are not created by the Viewer class");
    }

    public JPanel getJPanel(int n2) {
        if (this.j3dJPanels == null || n2 > this.j3dJPanels.length) {
            return null;
        }
        return this.j3dJPanels[n2];
    }

    public JPanel[] getJPanels() {
        if (this.j3dJPanels == null) {
            return null;
        }
        JPanel[] jPanelArray = new JPanel[this.j3dJPanels.length];
        for (int i2 = 0; i2 < this.j3dJPanels.length; ++i2) {
            jPanelArray[i2] = this.j3dJPanels[i2];
        }
        return jPanelArray;
    }

    public AudioDevice createAudioDevice() {
        if (physicalEnvironment == null) {
            System.err.println("Java 3D: createAudioDevice: physicalEnvironment is null");
            return null;
        }
        try {
            Object object;
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("j3d.audiodevice");
                }
            });
            if (string == null) {
                throw new UnsupportedOperationException("No AudioDevice specified");
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                object = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
                if (object == null) {
                    throw new IllegalStateException("System ClassLoader is null");
                }
                clazz = Class.forName(string, true, (ClassLoader)object);
            }
            object = PhysicalEnvironment.class;
            Constructor<?> constructor = clazz.getConstructor(new Class[]{object});
            PhysicalEnvironment[] physicalEnvironmentArray = new PhysicalEnvironment[]{physicalEnvironment};
            AudioEngine3DL2 audioEngine3DL2 = (AudioEngine3DL2)constructor.newInstance(physicalEnvironmentArray);
            audioEngine3DL2.initialize();
            return audioEngine3DL2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            physicalEnvironment.setAudioDevice(null);
            System.err.println("Java 3D: audio is disabled");
            return null;
        }
    }

    public SimpleUniverse getUniverse() {
        return this.getViewingPlatform().getUniverse();
    }

    void addWindowCloseListener(Window window) {
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl = true;
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                bl = false;
            }
        }
        final boolean bl2 = bl;
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                try {
                    window.dispose();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (bl2) {
                    System.exit(0);
                }
            }
        });
    }
}

